package com.androidbook.commoncontrols;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;

public class CheckBoxActivity extends Activity {
	    /** Wywoywane podczas pierwszego utworzenia aktywnoci. */
	    @Override
	    public void onCreate(Bundle savedInstanceState) {
	        super.onCreate(savedInstanceState);
	        setContentView(R.layout.checkbox);
	        
	        CheckBox fishCB = (CheckBox)findViewById(R.id.fishCB);

	        if(fishCB.isChecked())
                fishCB.toggle();        // jeeli pole wyboru byo zaznaczone, zostanie odznaczone

            fishCB.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {

				public void onCheckedChanged(CompoundButton arg0, boolean isChecked) {
					Log.v("CheckBoxActivity", "Pole wyboru Ryby jest teraz "
							+ (isChecked?"zaznaczone":"odznaczone"));					
				}});
	    }
	    
	    public void doClick(View view) {
	    	Log.v("CheckBoxActivity", "Pole wyboru Stek jest teraz " +
	    			(((CheckBox)view).isChecked()?"zaznaczone":"odznaczone"));
	    }
}
